* normal_quantile_plot_2.sas;
options pageno=1 linesize=80;
goptions reset=all;
title 'Fitting the normal to development data';
data devel_time;
	input time_pp time_adult;
	datalines;
34  65
31	48
29	 .
30	55
32	62
32	47
37	44
34	53
31	 .
37	53
32	 .
31	42
29	 .
35	 .
39	 .
34	43
32	 .
34	 .
34 113
32  47
32 100
41   .
32	49
29	 .
32	53
39	 .
39  84
35	 .
32	 .
35	74
36	43
31	50
34	 .
35	44
35 116
34   .
34	 .
37	58
36 101
32	67
34	68
34	61
28	66
31	84
30	68
28 106
28	42
31	58
31	42
28	68
32	55
32   .
30 101
30	99
39	43
30	80
28	52
27	50
28 110
28	42
30   .
28	66
28 147
27   .
37 135
30 119
29 113
30 103
30	95
27	87
29	89
33   .
27	76
27	 .
30	 .
30	49
30	81
29	85
27	 .
31 104
27	73
27 110
27   .
31	99
31	55
31	59
27	 .
30	93
27	 .
28	84
28	93
29	 .
29 108
31 103
33   .
29	92
;
run;
* Descriptive statistics, histograms, and normal quantile plots;
proc univariate plots data=devel_time;
	var time_pp time_adult;
	histogram time_pp time_adult / vscale=count normal(w=3) wbarline=3 waxis=3 height=4;
	qqplot time_pp time_adult / normal waxis=3 height=4;
	symbol1 h=3;
run;
quit;
